unit Jelolo2u;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    OldalEl: TEdit;
    GroupBox1: TGroupBox;
    FT: TCheckBox;
    LTL: TCheckBox;
    GroupBox2: TGroupBox;
    Kilepes: TButton;
    Label2: TLabel;
    Eredmeny1: TEdit;
    Label3: TLabel;
    Eredmeny2: TEdit;
    procedure KilepesClick(Sender: TObject);
    procedure OldalElChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FTClick(Sender: TObject);
    procedure LTLClick(Sender: TObject);
  private
    a: double; // a kocka oldalle
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

function Str2Dbl(const s: string):double;
var  dc : char;
begin
  dc := decimalseparator;
  if pos(',',s) <> 0 then
    decimalseparator := ','
  else
    decimalseparator := '.';
  try
     Str2Dbl := strToFloat(s);
  except
     Str2Dbl := 0;
  end;
  decimalseparator := dc;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  // a jellngyzetek alaprtkei
  FT.State  := cbChecked;
  FT.AllowGrayed := false; // a jellngyzet ktllapot,
                           // ez az alaprtelmezs
  LTL.State := cbChecked;
  LTL.AllowGrayed := true; // a jellngyzet hromllapot
  // a szvegmezk csak olvashatk
  Eredmeny1.ReadOnly := true;
  Eredmeny2.ReadOnly := true;
end;

procedure TForm1.OldalElChange(Sender: TObject);
begin
  a:= 0;
  Label2.Caption := '';
  Label3.Caption := '';
  Eredmeny1.Clear;
  Eredmeny2.Clear;
  if (length(OldalEl.Text)>1) and (OldalEl.Text[1] = '-')
      or (OldalEl.Text <> '') and (OldalEl.Text[1] <> '-')then
  begin
   a := Str2Dbl(OldalEl.Text);
   if a > 0 then
   begin
    if FT.State = cbChecked then
    begin
      Label2.Caption := 'Kocka felszine';
      Eredmeny1.Text := FloatToStr(6*a*a);
    end
    else
    begin
      Label2.Caption := 'Kocka trfogata';
      Eredmeny1.Text := FloatToStr(a*a*a);
    end;
    case LTL.State of
     cbChecked  :
       begin
         Label3.Caption := 'Laptl';
         Eredmeny2.Text := FloatToStr(sqrt(sqr(a)+sqr(a)));
       end;
     cbUnchecked:
       begin
         Label3.Caption := 'Testtl';
         Eredmeny2.Text := FloatToStr(a*sqrt(3));
       end;
     cbGrayed   :
       begin
         Label3.Caption := 'Lapterlet';
         Eredmeny2.Text := FloatToStr(a*a);
       end;
    end;
   end;
  end;
end;

procedure TForm1.FTClick(Sender: TObject);
begin
  if (length(OldalEl.Text) <> 0) and (a > 0)  then
  begin
    if FT.State = cbChecked then
    begin
      Label2.Caption := 'Kocka felszine';
      Eredmeny1.Text := FloatToStr(6*a*a);
    end
    else
    begin
      Label2.Caption := 'Kocka trfogata';
      Eredmeny1.Text := FloatToStr(a*a*a);
    end;
  end;
end;

procedure TForm1.LTLClick(Sender: TObject);
begin
  if (length(OldalEl.Text) <> 0) and (a > 0) then
  begin
   case LTL.State of
     cbChecked  :
       begin
         Label3.Caption := 'Laptl';
         Eredmeny2.Text := FloatToStr(sqrt(sqr(a)+sqr(a)));
       end;
     cbUnchecked:
       begin
         Label3.Caption := 'Testtl';
         Eredmeny2.Text := FloatToStr(a*sqrt(3));
       end;
     cbGrayed   :
       begin
         Label3.Caption := 'Lapterlet';
         Eredmeny2.Text := FloatToStr(a*a);
       end;
    end;
  end;
end;

procedure TForm1.KilepesClick(Sender: TObject);
begin
  Application.Terminate;
end;

end.
